
/*! \file 
**********************************************************************************
*Title:                         Discretix OMA DRM v2 Secure RO Handling ATP Test source file
*
* Filename:                     ODRM_SecROHandling_RoPreProcessing_ATP.h 
*
* 
* Created:                      17.03.2009
*
*
* \Author                      Shelly Lerman
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/


#ifndef _ODRM_SEC_RO_HANDLING_PRE_PROCESSING_ATP_H_
#define _ODRM_SEC_RO_HANDLING_PRE_PROCESSING_ATP_H_

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/


#ifdef __cplusplus
extern "C"
{
#endif


/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_PreProcessingAndActivation
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test License Pre-Processing using device private key in Secure RO Handling 
* Algorithm:
* 1. Get workspace size. 
* 2. Create key ring and initialize it with device private key
* 3. Call to  TLK_ODRM_ProcessRegistration() API for RI Issuer registration
* 4. Call to  TLK_ODRM_VerifyDeviceRoBeforeInstall() API with the device private key .
* 5. Verify that the returned key ring contains the correct keys (according to their usage flags). 
* 6. Activate content license using  TLK_ODRM_RetrieveKey() with KMAC and KREK keys from step 4 and secure clock descriptor from step 3.
* 7. Validate that  this is correct RO key.
*    7.1 Encrypt Plain text with the activated RO key from TLK_ODRM_RetrieveKey().
*    7.2 compare it to the Encrypted plain text with the 
*        original RO key
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_PreProcessingAndActivation(void);


/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_PreProcessingWithInvalidFlag
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test license pre-processing with invalid usage flag of device private key
* Algorithm:
*1. Get workspace size. 
*2. Create key ring and initialize it 
*3. Import a device private key with invalid usage flag
*4. Call to TLK_ODRM_VerifyDeviceRoBeforeInstall()  API with invalid usage flag of device private key
*5. Verify that correct error was returned
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_PreProcessingWithInvalidFlag(void);

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_PreProcessingWithInvalidRO
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test license pre-processing with invalid RO XML
* Algorithm:
*1. Get workspace size. 
*2. Create key ring and initialize it 
*3. Import a device private key 
*4. Call to TLK_ODRM_VerifyDeviceRoBeforeInstall()  API with invalid RO XML structure (RO integrity)
*5. Verify that correct error was returned
*6. Call to TLK_ODRM_VerifyDeviceRoBeforeInstall()  API with invalid Key in RO XML structure 
*7. Verify that correct error was returned
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_PreProcessingWithInvalidRO(void);

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_DomainRoInstWithInvalidFlag
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test license pre-processing with domain key  using invalid usage flag
* Algorithm:
* 1. Get workspace size. 
* 2. Create key ring and initialize it.
* 3. Import domain key using invalid usage flag
* 4. Call to TLK_ODRM_VerifyDomainRoBeforeInstall() API with Domain key from step 3.
* 5. Verify that correct error was returned
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_DomainRoInstWithInvalidFlag(void);

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_DomainRoInstWithInvalidKey
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
* To test license pre-processing with invalid domain key 
* Algorithm:
* 1. Get workspace size. 
* 2. Create key ring and initialize it.
* 3. Import invalid domain key 
* 4. Call to TLK_ODRM_VerifyDomainRoBeforeInstall() API with Domain key from step 3.
* 5. Verify that correct error was returned
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_DomainRoInstWithInvalidKey(void);

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_DomainRoInstWithInvPassword
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test license pre-processing with domain key using invalid key ring password 
* Algorithm:
* 1.Get workspace size. 
* 2.Create key ring and initialize it with not RI ID password.
* 3.Import domain key 
* 4.Call to TLK_ODRM_VerifyDomainRoBeforeInstall() API with Domain key from step 3.
* 5.Verify that correct error was returned
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_DomainRoInstWithInvPassword(void);

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_InvalidROActivation
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test activation of license with invalid RO XML Secure RO Handling 
* Algorithm:
* 1. Get workspace size. 
* 2. Create key ring and initialize it with device private key
* 3. Call to  TLK_ODRM_ProcessRegistration() API  for RI Issuer registration
* 4. Call to TLK_ODRM_VerifyDeviceRoBeforeInstall() API with the device private key and RO XML.
* 5. Activate content license using  TLK_ODRM_RetrieveKey() with keys from step 4, secure clock descriptor from step 3and invalid RO XML (RO integrity).
* 6. Verify that correct error was returned
* 7.Activate content license using  TLK_ODRM_RetrieveKey() with keys from step 4, secure clock descriptor from step 3 and invalid key in RO XML.
* 8.Verify that correct error was returned
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_InvalidROActivation(void);

/*****************************************************************************
* Function Name:                                                           
*  TST_ATP_SEC_RO_InvalidParentROActivation
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return                                        
*
* TEST DESCRIPTION:
*  To test activation of license with invalid Parent RO XML Secure RO Handling
* Algorithm:
* 1. Get workspace size. 
* 2. Create key ring and initialize it with device private key
* 3. Call to  TLK_ODRM_ProcessRegistration() API  for RI Issuer registration
* 4. Call to TLK_ODRM_VerifyDeviceRoBeforeInstall() API with the device private key and RO XML.
* 5. Call to TLK_ODRM_VerifyDeviceRoBeforeInstall() API with the device private key and Parent RO XML.
* 6. Activate content license using  TLK_ODRM_RetrieveKey() with keys from step 4, 5, secure clock descriptor from step 3and invalid Parent RO XML (RO integrity).
* 7. Activate content license using  TLK_ODRM_RetrieveKey() with keys from step 4, 5, secure clock descriptor from step 3 and invalid key in RO XML. 
* 8. Verify that correct error was returned
*******************************************************************************/   
DxError_t TST_ATP_SEC_RO_InvalidParentROActivation(void);

#ifdef __cplusplus
}
#endif

#endif
